% this script reads imaris files and measures the centrosomal protein
% intensity sum and volume sum. Written by Ingrid Brust-Mascher and Xueer Jiang,
% Jao lab, University of California, Davis (April 2019). Publications that
% have utilized this script should acknowledge the resource and cite our
% Bio-Protocol Paper.






clear
% define fpath: location of a folder containing the processed imaris images
fpath='/Users/jao_lab/Documents/MATLAB/bio_protocol_images_control';

% define protein surface of interest for quantification
protein_surface_number = 2;

% define the original and deconvolved channel number of  protein surface of
% interest
ori_protein_channel_number = '5';
decon_protein_channel_number = '2';

% define intensity sum channel number for generalization
intensity_sum = 'Intensity Sum Channel';
ori_intensity_sum_channel_protein = [intensity_sum, ' ', ori_protein_channel_number];
decon_intensity_sum_channel_protein = [intensity_sum, ' ', decon_protein_channel_number];

% use dir function to list folder contents and select imaris files
ImarisImages=dir(fullfile(fpath,'*.ims'));

% define numbers of files
NumberImages=length(ImarisImages);

% define result as matrix of 0
result = zeros(NumberImages,4);

for k=1:NumberImages   
   % filename to analyze 
   filename=ImarisImages(k).name;       

   % create filenames of directory files                
    xPath=fullfile(fpath,filename);   
    
   % read imaris files using ImarisReader function
   imsObj=ImarisReader(xPath);  
   
   % index surface statisitics of protein of interest
   SurfaceStatistics=imsObj.Surfaces(protein_surface_number).GetStatistics; 
   
   % from SurfaceStatistics get centrosome coordinates centro (2x3 matrix)
   
   % define number of surface statisitics
   NumberSurStats=length(SurfaceStatistics);  
   
   for i=1:NumberSurStats
       % extract volume statistics
       if strcmp (SurfaceStatistics(i).Name,"Volume") 
           Volume=SurfaceStatistics(i).Value;
           
       % extract decon intensity sum of protein of interest
        elseif strcmp (SurfaceStatistics(i).Name,decon_intensity_sum_channel_protein) 
           DeconIntensitySum=SurfaceStatistics(i).Value;
           
       % extract original intensity sum of protein of interest
        elseif strcmp (SurfaceStatistics(i).Name,ori_intensity_sum_channel_protein)      
           OriginalIntensitySum=SurfaceStatistics(i).Value;
        end
   end
   NumberProteinSurfaces=size(Volume);
   centro=zeros(2,3);
   largest=0;
   for j=1:2
       for i=1:NumberProteinSurfaces
           if Volume(i)==max(Volume)
               centro(j,3)=DeconIntensitySum(i);
               centro(j,2)=OriginalIntensitySum(i);
               centro(j,1)=Volume(i);
               largest=i;
           end
       end
       Volume(largest)=0;
   end
   
   % collect results into a matrix
   result(k,1)=k;
   result(k,2)=centro(1,1)+centro(2,1);
   result(k,3)=centro(1,2)+centro(2,2);
   result(k,4)=centro(1,3)+centro(2,3);
   
end % for number of images

% convert matrix to table and define column names
 table_result = array2table(result);
 
% define variable names for the table
 table_result.Properties.VariableNames{'result1'} = 'image_order';
 table_result.Properties.VariableNames{'result2'} = 'sum_centrosome_volume';
 table_result.Properties.VariableNames{'result3'} = 'original_centrosome_intensity_sum';
 table_result.Properties.VariableNames{'result4'} = 'centrosome_intensity_sum_in_decon_channel';

% define output name and format
outputfile = 'original centrosome intensity sum.csv'; 

% define output path
OutputPath = fullfile(fpath,outputfile);

% output as csv table spreadsheet
writetable(table_result,OutputPath); 

